/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.fru;

import com.ibm.hwmca.base.pa.fru.HmcFruList;
import com.ibm.hwmca.base.pa.fru.HmcFruResolverKey;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdInputData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonFruList;
import com.ibm.hwmca.xfw.pa.fru.CommonFruListKey;
import com.ibm.hwmca.xfw.pa.fru.CommonFruResolver;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HmcFruResolver
implements CommonFruResolver {
    private static final String TRACE_MASKT = "XPAFRURT";
    private static final String TRACE_MASKF = "XPAFRURF";
    private static final String TRACE_MASKD = "XPAFRURD";
    private static final boolean UNIT_TEST = true;
    private static final String FRU_TABLE_NAME = "frutable.xml";
    private static final String LOCATION_NODE = "location";
    private static final String VALUE_NODE = "value";
    private static final String VERIFICATION_NODE = "verification";
    private static final String ISOLATION_NODE = "isolation";
    private static final String PERCENT_NODE = "percent";
    private static final String FRU_NODE = "fru";
    private static final String TYPE_NODE = "type";
    private static final String NAME_ATTRIB = "name";
    private Map _fruMap;

    public HmcFruResolver() throws HException {
        Trace.trace(TRACE_MASKD, "--> HmcFruResolver");
        this._fruMap = this.buildFruMap();
        Trace.trace(TRACE_MASKD, "<-- HmcFruResolver");
    }

    public CommonFruList resolve(CommonFruListKey cflKey) throws HException {
        HmcFruList fruList = null;
        HmcFruResolverKey key = (HmcFruResolverKey)cflKey;
        Trace.trace(TRACE_MASKD, "==>resolve");
        if (cflKey == null) {
            Trace.trace(TRACE_MASKD, "key= null");
        } else {
            Trace.trace(TRACE_MASKD, "key != null");
        }
        Trace.trace(TRACE_MASKD, "refcode = " + key.getRefcode());
        Trace.trace(TRACE_MASKD, "id = " + key.getXMLId());
        if (cflKey instanceof HmcFruResolverKey) {
            Trace.trace(TRACE_MASKD, "refcode = " + key.getRefcode());
            Trace.trace(TRACE_MASKD, "id = " + key.getXMLId());
            try {
                fruList = this.getFruList(key);
                this.resolveFrus(fruList);
                return fruList;
            }
            catch (Exception e) {
                HException hexc = new HException(e);
                String text = "Error resolving refcode =" + key.getRefcode();
                hexc.add(text);
                throw hexc;
            }
        }
        return fruList;
    }

    private HmcFruList getFruList(HmcFruResolverKey key) throws HException, FileNotFoundException, SAXException, IOException {
        Trace.trace(TRACE_MASKD, "--> Get FruList");
        String filePath = BaseFileControl.getFilePath("paconfig");
        FileInputStream fis = new FileInputStream(filePath + key.getXMLId());
        Document fitDoc = new HwmcaParser(fis, false).getDocument();
        Trace.trace(TRACE_MASKD, "done parsing fitDoc");
        Node refcodeNode = this.getRefcodeNode(key.getRefcode(), fitDoc);
        HmcFruList aFruList = new HmcFruList();
        aFruList.setVerification(this.getValueOfNode(VERIFICATION_NODE, refcodeNode));
        aFruList.setIsolation(this.getValueOfNode(ISOLATION_NODE, refcodeNode));
        aFruList.setFrus(this.getFrus(refcodeNode));
        aFruList.setType(this.getValueOfNode(TYPE_NODE, refcodeNode));
        Trace.trace(TRACE_MASKD, "<-- Get FruList");
        return aFruList;
    }

    private Map buildFruMap() throws HException {
        Trace.trace(TRACE_MASKD, "--> buildFruMap");
        HashMap<String, String> fruMap = new HashMap<String, String>();
        try {
            String filePath = BaseFileControl.getFilePath("paconfig");
            FileInputStream fis = new FileInputStream(filePath + FRU_TABLE_NAME);
            Document fruDoc = new HwmcaParser(fis, false).getDocument();
            Trace.trace(TRACE_MASKD, "done parsing fruDoc");
            NodeList nodes = fruDoc.getElementsByTagName(FRU_NODE);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String name = nodes.item(i).getAttributes().getNamedItem(NAME_ATTRIB).getNodeValue();
                Trace.trace(TRACE_MASKD, "fru name = " + name + ".");
                NodeList children = nodes.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (!LOCATION_NODE.equals(child.getNodeName().toLowerCase())) continue;
                    String location = HmcFruResolver.getValue(child);
                    Trace.trace(TRACE_MASKD, "location = " + location + ".");
                    Trace.trace(TRACE_MASKD, "add (" + name + "), (" + location + ") it to the map");
                    fruMap.put(name, location);
                }
            }
            Trace.trace(TRACE_MASKD, "<-- buildFruMap");
            return fruMap;
        }
        catch (Exception e) {
            HException hexc = new HException(e);
            String text = "Error building FRU table map";
            hexc.add(text);
            throw hexc;
        }
    }

    private void resolveFrus(HmcFruList frulist) {
        CommonPaFru[] fruList = frulist.getFrus();
        for (int i = 0; i < fruList.length; ++i) {
            String symFru = fruList[i].getName();
            Trace.trace(TRACE_MASKD, "working with fru (" + symFru + ")");
            String location = (String)this._fruMap.get(symFru);
            Trace.trace(TRACE_MASKD, "fru location to look up =" + location);
            VpdManager vpdMan = VpdManager.getVpdManager();
            VpdData vpdRequestData = new VpdData(VpdRequestValue.REQUEST_CUR_BAK);
            try {
                Trace.trace(TRACE_MASKD, "call VPD");
                VpdInputData inputData = new VpdInputData();
                inputData.setFruLocation(location);
                vpdRequestData.setVpdInputData(inputData);
                vpdRequestData = vpdMan.callVpdManager(vpdRequestData);
                Trace.trace(TRACE_MASKD, "back from VPD");
                fruList[i].setPartNumber(vpdRequestData.getVpdFruExistData().getPartNumber());
                fruList[i].setECLevel(vpdRequestData.getVpdFruExistData().getEcLevel());
                fruList[i].setSerialNumber(vpdRequestData.getVpdFruExistData().getSerialNumber());
                Trace.trace(TRACE_MASKD, "Part number   =" + fruList[i].getPartNumber());
                Trace.trace(TRACE_MASKD, "ec            =" + fruList[i].getECLevel());
                Trace.trace(TRACE_MASKD, "Serial number =" + fruList[i].getSerialNumber());
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "VPD Error");
                fruList[i].setPartNumber("VPD Error");
                fruList[i].setECLevel("VPD Error");
                fruList[i].setSerialNumber("VPD Error");
            }
        }
    }

    private Node getRefcodeNode(String refcode, Document fitDoc) {
        Trace.trace(TRACE_MASKD, "-->GetRefcodeNode for rc = " + refcode + ".");
        NodeList nodes = fitDoc.getElementsByTagName("refcode");
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeList children = nodes.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                String value;
                Node child = children.item(j);
                if (!VALUE_NODE.equals(child.getNodeName().toLowerCase()) || !refcode.equals(value = HmcFruResolver.getValue(child))) continue;
                Trace.trace(TRACE_MASKD, "Found it");
                return nodes.item(i);
            }
        }
        Trace.trace(TRACE_MASKD, "Didn't find the node");
        return null;
    }

    private CommonPaFru[] getFrus(Node refcodeNode) {
        ArrayList<CommonPaFru> myArray = new ArrayList<CommonPaFru>();
        NodeList children = refcodeNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!FRU_NODE.equals(child.getNodeName().toLowerCase())) continue;
            Trace.trace(TRACE_MASKD, "found a fru to add");
            String fruName = child.getAttributes().getNamedItem(NAME_ATTRIB).getNodeValue().trim();
            try {
                CommonPaFru aFru = (CommonPaFru)ServiceInterfaces.getFactory("com.ibm.hwmca.fw.pa.system.PASystem", "Fru");
                aFru.setName(fruName);
                aFru.setPercent(this.getValueOfNode(PERCENT_NODE, child));
                myArray.add(aFru);
                Trace.trace(TRACE_MASKD, "add fru named (" + fruName + ")");
                continue;
            }
            catch (ServiceInterfacesException e) {
                e.printStackTrace();
                Trace.trace(TRACE_MASKT, "<-> HmcFruResolver could not generate a fru return ");
                Trace.trace(TRACE_MASKT, e);
                return new CommonPaFru[myArray.size()];
            }
        }
        CommonPaFru[] returnArray = new CommonPaFru[myArray.size()];
        ListIterator listIterator = myArray.listIterator();
        int i = 0;
        while (listIterator.hasNext()) {
            returnArray[i] = (CommonPaFru)listIterator.next();
            ++i;
        }
        return returnArray;
    }

    private static String getValue(Node node) {
        String value = "";
        NodeList nodes = node.getChildNodes();
        if (nodes.getLength() > 0) {
            Node nextNode = nodes.item(0);
            value = nextNode.getNodeValue().trim();
        }
        return value;
    }

    private String getValueOfNode(String nodeName, Node node) {
        Trace.trace(TRACE_MASKD, "-->getValueOfNode of " + nodeName);
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!nodeName.equals(child.getNodeName().toLowerCase())) continue;
            Trace.trace(TRACE_MASKD, "<-- getValueOfNode returned = " + HmcFruResolver.getValue(child));
            return HmcFruResolver.getValue(child).trim();
        }
        return null;
    }

    private String getAttribOfNode(String nodeName, Node node) {
        Trace.trace(TRACE_MASKD, "-->getValueOfNode of " + nodeName);
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!nodeName.equals(child.getNodeName().toLowerCase())) continue;
            Trace.trace(TRACE_MASKD, "<-- getValueOfNode returned = " + HmcFruResolver.getValue(child));
            return HmcFruResolver.getValue(child).trim();
        }
        return null;
    }
}

